//
//  SleepDetailViewController.swift
//  CTFit
//
//  Created by Mac on 2020/5/29.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager

class SleepDetailViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    private override init() {
        super.init()
        navigationItem.title = SRString.Sleep.sleep.locastr
    }
    
    convenience init(date: Date = Date()) {
        self.init()
        datasource = SleepDayDatasource(date: date)
    }
        
    override func loadView() {
        super.loadView()
        view = ViewClass()
        customView.reloadForRecord()
        customView.groundImage.image =  IntervalStyle.day.sleepGroundImage
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
   
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidLoad()
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = self.shareBarItem()
    }
    
    // MARK: - tableViewManger

    fileprivate var datasource: SleepDayDatasource!
    
    fileprivate lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(DateBarCell.self, DateBarItem.self)
        manager.register(SleepDayCell.self, SleepDayItem.self)
        manager.register(SleepHeartCell.self, SleepHeartItem.self)
        manager.add(section: dateBarSection)
        manager.add(section: sleepDaySection)
        manager.add(section: sleepHeartSection)
        return manager
    } ()
    
    fileprivate lazy var dateBarSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.1
        section.add(item: datasource.dateBarItem)
        return section;
    } ()
    
    fileprivate lazy var sleepDaySection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.1
        section.add(item: datasource.sleepDaytItem)
        return section;
    } ()
    
    fileprivate lazy var sleepHeartSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.1
        section.add(item: datasource.sleepHeartItem)
        return section;
    } ()


    private func setupTableView() {
        customView.tableView.separatorStyle = .none
        tableViewManger.reload()
    }
    
}
