//
//  SleepHeartCell.swift
//  CTFit
//
//  Created by Mac on 2020/6/6.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import SnapKit
import TableViewManager
import Charts

final class SleepHeartCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: -  ZJCellProtocol
    
    var item: SleepHeartItem!

    typealias ZJCelltemClass = SleepHeartItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        guard item != nil else { return }
        update(item.heartRecords)
    }
    
    // MARK: - Initialize
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        backgroundColor = .clear
        addSubviews()
    }
    
    // MARK: -  View customer
    
    private func addSubviews() {
        [lineChart].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        lineChart.snp.makeConstraints { (make) in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(Constraints.small)
            make.bottom.equalToSuperview().offset(-Constraints.small)
            make.height.equalTo(140)
        }
    }

    /// 心率图表
    private lazy var lineChart: LineChartView = {
        let chart = LineChartView()
        ChartsUtils.HeartRate.sleep(chart)
        return chart
    } ()
}


// MARK: - Update

extension SleepHeartCell {
   
    private func update(_ heartRecords: [UInt8]?) {
        updateChartData(heartRecords)
    }
    
    /// 设置图表数据: Y轴表示10分钟一次的 静态心率数据
    private func updateChartData(_ values: [UInt8]?) {
        lineChart.highlightValue(nil)
        var entries = [ChartDataEntry]();
        if let hasValues = values {
            for (index, value) in hasValues.enumerated() {
                entries.append(ChartDataEntry(x: Double(index), y: Double(value)));
            }
        } else {
            lineChart.data = nil;
            lineChart.notifyDataSetChanged();
            return;
        }
        
        var set: LineChartDataSet!;
        if let hasData = lineChart.data, hasData.dataSetCount > 0 {
            set = hasData.dataSets[0] as? LineChartDataSet;
            set.replaceEntries(entries)
            hasData.notifyDataChanged();
            lineChart.notifyDataSetChanged();
        } else {
            set = LineChartDataSet(entries: entries, label: "Sleep Heartrate");
            set?.valueTextColor = UIColor.clear//设置折线上的字体颜色 - 运动距离页面
            set.mode = .cubicBezier;
            set.drawCirclesEnabled = false;
            set.drawCircleHoleEnabled = false;
            set.formLineWidth = 1;
            set.formSize = 15;
            set.formLineDashLengths = [5, 2.5];
            
            set.colors = [UIColor.green, UIColor.yellow, UIColor.red];
            set.drawFilledEnabled = true // Draw the Gradient
      
            let dataSets = [set];
            let data = LineChartData(dataSets: dataSets as? [IChartDataSet]);
            self.lineChart.data = data;
        }
        
    }
}
