//
//  StepDayDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/6/4.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import RxSwift

final class StepDayDatasource {
    
    var didUpdateExerciseItems: (()->Void)?
        
    let dateBarItem: DateBarItem = DateBarItem(date: Date())
    
    let stepDayItem: StepDayItem = StepDayItem()

    var exerciseItems: [ExerciseItem]  = [ExerciseItem] ()

    init(date: Date = Date()) {
        dateBarItem.date = date
        queary()
        observers()
        dateBarItem.onValueChanged { [weak self] (dateBar) in
            guard let strong = self else { return }
            strong.queary()
        }
        BandCommand.readRecordDetailToday(with: .total)
        BandCommand.readRecordDetailToday(with: .step)
        BandCommand.readRecordDetailToday(with: .exercise)
    }
    
    var dateStr: String { dateFormatter.string(from: dateBarItem.date) }
    
    lazy var dateFormatter :DateFormatter = {
        let formatter = DateFormatter();
        formatter.dateFormat = "yyyy-MM-dd";
        return formatter;
    }()
    
    private func queary() {
        BandData.queryStepDetail(with: dateBarItem.date) { [weak self] (total, step, exercise) in
            guard let strong = self else { return }
            strong.stepDayItem.total = total ?? BDTotal()
            strong.stepDayItem.step = step
            strong.stepDayItem.reload()
            strong.exerciseItems.removeAll()
            if let hasExercise = exercise {
                for item in hasExercise.records {
                    strong.exerciseItems.insert(ExerciseItem(with: item), at: 0)
                }
            }
            if let block = strong.didUpdateExerciseItems { block() }
        }
    }
    
    private func observers() {
        BandData.updatedOutput.observeOn(MainScheduler.instance).subscribe(onNext: { [weak self] (type) in
            guard let strong = self else { return }
            switch type {
            case .record(let type, let dateStr):
                guard dateStr == strong.dateStr else { return }
                switch type {
                case .exercise: strong.queary()
                default: break
                }
            default : break
            }
        }).disposed(by: disposeBag)
        
        
        BandSettings.observable.subscribe(onNext: { [weak self] (options) in
            guard let strong = self else { return }
            guard options.contains(.system) || options.contains(.goal) else { return }
            strong.stepDayItem.reload()
            strong.exerciseItems.forEach { (item) in item.reload() }
            
        }).disposed(by: disposeBag)
    }
    
    // MARK: - Private field
    private lazy var disposeBag = DisposeBag()
}
