//
//  StepDetailViewController.swift
//  CTFit
//
//  Created by NEIL on 2020/5/28.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager

class StepDetailViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    override init() {
        super.init()
        navigationItem.title = SRString.Step.step.locastr
    }
    
    convenience init(date: Date = Date()) {
        self.init()
        datasource = StepDayDatasource(date: date)
    }
        
    override func loadView() {
        super.loadView()
        view = ViewClass()
        customView.reloadForRecord()
        customView.groundImage.image = IntervalStyle.day.stepGroundImage
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
   
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = self.shareBarItem()
    }

    var datasource: StepDayDatasource!
    
    fileprivate lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(DateBarCell.self, DateBarItem.self)
        manager.register(StepDayCell.self, StepDayItem.self)
        manager.register(ExerciseCell.self, ExerciseItem.self)
        manager.add(section: dateBarSection)
        manager.add(section: stepSection)
        manager.add(section: exerciseSection)
        return manager
    } ()
    
    fileprivate lazy var dateBarSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.add(item: datasource.dateBarItem)
        return section;
    } ()
    
    fileprivate lazy var stepSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.add(item: datasource.stepDayItem)
        return section;
    } ()
    
    fileprivate lazy var exerciseSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        datasource.exerciseItems.forEach { (e) in section.add(item: e)  }
        return section;
    } ()

    private func setupTableView() {
        self.customView.tableView.separatorStyle = .none
        initDatasource();
    }
    
    private func initDatasource() {
        tableViewManger.reload();
        datasource.didUpdateExerciseItems = { [weak self] () in
            guard let strong = self else { return }
            strong.updateExerciseItems()
        }
    }
    
    private func updateExerciseItems() {
        exerciseSection.removeAllItems()
        datasource.exerciseItems.forEach { (e) in exerciseSection.add(item: e)  }
        exerciseSection.reload()
        customView.layoutSubviews()
    }
}
