//
//  StatisticsSleepViewController.swift
//  CTFit
//
//  Created by Mac on 2020/5/29.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class RecordSleepViewController: BaseViewController, CustomView {
    
    typealias ViewClass = RecordPageView
        
    private lazy var date: Date = Date()
    
    private override init() {
        super.init()
        hidesBottomBarWhenPushed = true
        navigationItem.title = SRString.Sleep.sleep.locastr
    }
    
    convenience init(date: Date = Date()) {
        self.init()
        self.date = date
    }

       
    override func loadView() {
        super.loadView()
        view = ViewClass(superController: self)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupSubviews()
    }

    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }

    
    private func setupSubviews() {
        self.customView.viewControllers = [SleepDetailViewController(date: date),
                                           SleepIntervalViewController(with: .week, date: date),
                                           SleepIntervalViewController(with: .month, date: date),
                                           SleepIntervalViewController(with: .year, date: date)]
    }

}
