//
//  StatisticsStepViewController.swift
//  CTFit
//
//  Created by Mac on 2020/5/29.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class RecordStepViewController: BaseViewController, CustomView {
    
    typealias ViewClass = RecordPageView
    
    private lazy var date: Date = Date()
    
    private override init() {
        super.init()
        hidesBottomBarWhenPushed = true
        navigationItem.title = SRString.Step.step.locastr
    }
    
    convenience init(date: Date = Date()) {
        self.init()
        self.date = date
    }
       
    override func loadView() {
        super.loadView()
        view = ViewClass(superController: self)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupSubviews()
    }

    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    private func setupSubviews() {
        self.customView.viewControllers = [StepDetailViewController(date: date),
                                           StepIntervalViewController(with: .week, date: date),
                                           StepIntervalViewController(with: .month, date: date),
                                           StepIntervalViewController(with: .year, date: date)]
    }

}
