//
//  SleepIntervalDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/6/10.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation

final class SleepIntervalDatasource {
        
    let intervalStyle: StatisticalIntervalStyle

    let dateBarItem: DateBarItem
    
    let sleepItem: SleepIntervalItem
    
    
    init(with date: Date = Date(), intervalStyle: StatisticalIntervalStyle) {
        
        self.intervalStyle = intervalStyle
        
        dateBarItem = DateBarItem(with: intervalStyle.dateBarStyle, date: date)
        
        sleepItem = SleepIntervalItem(with: intervalStyle)
        
        dateBarItem.onValueChanged { [weak self] (dateBar) in
            guard let strong = self else { return }
            strong.queary()
        }
        queary()
    }
    
    private func queary() {
        BandData.querySleepInterval(frome: dateBarItem.dateInterval.start, to: dateBarItem.dateInterval.realEnd) { [weak self] sleepArray in
            guard let strong = self else { return }
            strong.update(sleepArray)
        }
    }
    
    private func update(_ sleepArray: [BDSleep]) {
        sleepItem.sleepItem = SleepIntervalModel(style: intervalStyle, dateInterval: dateBarItem.dateInterval, sleepArray: sleepArray)
        sleepItem.reload()
    }
}
