//
//  SleepIntervalViewController.swift
//  CTFit
//
//  Created by Mac on 2020/6/10.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager

class SleepIntervalViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    fileprivate(set) var intervalStyle: StatisticalIntervalStyle = .week

    override private init() {
        super.init()
        navigationItem.title = SRString.Sleep.sleep.locastr
    }

    convenience init(with intervalStyle: StatisticalIntervalStyle = .week, date: Date = Date()) {
        self.init()
        self.intervalStyle = intervalStyle
        datasource = SleepIntervalDatasource(with: date, intervalStyle: intervalStyle)
    }
        
    override func loadView() {
        super.loadView()
        view = ViewClass()
        customView.reloadForRecord()
        customView.groundImage.image = intervalStyle.dateBarStyle.sleepGroundImage

    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
   
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }

    var datasource: SleepIntervalDatasource!
    var tableViewManger: ZJTableViewManager!;
    let section = ZJTableViewSection();

    private func setupTableView() {
        self.customView.tableView.separatorStyle = .none
        section.headerHeight = 0.01;
        tableViewManger = ZJTableViewManager(tableView: customView.tableView)
        tableViewManger.register(DateBarCell.self, DateBarItem.self)
        tableViewManger.register(SleepIntervalCell.self, SleepIntervalItem.self)
        tableViewManger.add(section: section);
        initDatasource();
    }
    
    
    private func initDatasource() {
        datasource.sleepItem.autoHeight(tableViewManger)
        section.add(item: datasource.dateBarItem)
        section.add(item: datasource.sleepItem)
        tableViewManger.reload();
    }
}
