//
//  StepIntervalDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/6/4.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import RxSwift

enum StatisticalIntervalStyle {
    case week
    case month
    case year
    
    var dateBarStyle: IntervalStyle  {
        switch self {
        case .week: return.week
        case .month: return.month
        case .year: return.year
        }
    }
    
    func timePerid(_ dateInterval: DateInterval) -> String {
        switch self {
        case .week: return IntervalStyle.timePeridWeek(dateInterval)
        case .month: return IntervalStyle.timePeridMonth(dateInterval)
        case .year: return IntervalStyle.timePeridYear(dateInterval)
        }
    }
}

final class StepIntervalDatasource {
        
    let intervalStyle: StatisticalIntervalStyle

    let dateBarItem: DateBarItem
    
    let stepItem: StepIntervalItem
    
    let exerciseItem: StatisticsExerciseItem

    
    init(with date: Date = Date(), intervalStyle: StatisticalIntervalStyle) {
        
        self.intervalStyle = intervalStyle
        
        dateBarItem = DateBarItem(with: intervalStyle.dateBarStyle, date: date)
        
        stepItem = StepIntervalItem(with: intervalStyle)
        
        exerciseItem = StatisticsExerciseItem(with: intervalStyle)
        
        queary()
        
        observers()
        
        dateBarItem.onValueChanged { [weak self] (dateBar) in
            guard let strong = self else { return }
            strong.queary()
        }
    }
    
    private func queary() {
        BandData.queryStepInterval(frome: dateBarItem.dateInterval.start, to: dateBarItem.dateInterval.realEnd) { [weak self] (totalArray, exerciseArray) in
            guard let strong = self else { return }
            strong.update(totalArray, exerciseArray)
        }
    }
    
    private func update(_ totalArray: [BDTotal], _ exerciseArray: [BDExercise]) {
        stepItem.model = StepIntervalModel(style: intervalStyle, dateInterval: dateBarItem.dateInterval, totoalArray: totalArray)
        exerciseItem.statisticExerciseModel = StatisticExerciseModel(with: exerciseArray)
        stepItem.reload()
        exerciseItem.reload()
    }
    
    private func observers() {
        BandSettings.observable.subscribe(onNext: { [weak self] (options) in
            guard let strong = self else { return }
            guard options.contains(.system) || options.contains(.goal) else { return }
            strong.stepItem.reload()
        }).disposed(by: disposeBag)
    }
    
    // MARK: - Private field
    private lazy var disposeBag = DisposeBag()
}
