//
//  StepIntervalViewController.swift
//  CTFit
//
//  Created by Mac on 2020/5/29.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager

class StepIntervalViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    fileprivate(set) var intervalStyle: StatisticalIntervalStyle = .week

    override private init() {
        super.init()
        navigationItem.title = SRString.Step.step.locastr
    }


    convenience init(with intervalStyle: StatisticalIntervalStyle = .week, date: Date = Date()) {
        self.init()
        self.intervalStyle = intervalStyle
        datasource = StepIntervalDatasource(with: date, intervalStyle: intervalStyle)
    }
        
    override func loadView() {
        super.loadView()
        view = ViewClass()
        customView.reloadForRecord()
        customView.groundImage.image = intervalStyle.dateBarStyle.stepGroundImage

    }

    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = shareBarItem()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
   
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }

    var datasource: StepIntervalDatasource!
    var tableViewManger: ZJTableViewManager!;
    let section = ZJTableViewSection();

    private func setupTableView() {
        self.customView.tableView.separatorStyle = .none
        section.headerHeight = 0.01
        tableViewManger = ZJTableViewManager(tableView: customView.tableView)
        tableViewManger.register(DateBarCell.self, DateBarItem.self)
        tableViewManger.register(StepIntervalCell.self, StepIntervalItem.self)
        tableViewManger.register(StatisticsExerciseCell.self, StatisticsExerciseItem.self)
        tableViewManger.add(section: section);
        initDatasource();
    }
    
    private func initDatasource() {
        datasource.stepItem.autoHeight(tableViewManger)
        datasource.exerciseItem.autoHeight(tableViewManger)
        section.add(item: datasource.dateBarItem)
        section.add(item: datasource.stepItem)
        section.add(item: datasource.exerciseItem)
        tableViewManger.reload();
    }
}
