//
//  StatisticsExerciseItem.swift
//  CTFit
//
//  Created by Mac on 2020/6/9.
//  Copyright © 2020 shirajo. All rights reserved.
//


import Foundation
import TableViewManager

final class StatisticsExerciseItem: BaseTableViewItem {
    
    private(set) var intervalStyle: StatisticalIntervalStyle = .week
    
    var statisticExerciseModel: StatisticExerciseModel = StatisticExerciseModel()
    
    private override init() {
        super.init()
        selectionStyle = .none
        accessoryType = .none
        isAutoHeight = true
    }
    
    convenience init(with intervalStyle: StatisticalIntervalStyle = .week) {
        self.init()
        self.intervalStyle = intervalStyle
    }
}


/// 训练统计
class StatisticExerciseModel {
    
    /// 总次数
    var count: Int = 0;
    
    /// 各种运动次数统计
    var records: [BDSportType: Int] = [BDSportType: Int]()
    
    init(with exerciseArray: [BDExercise] = []) {
        exerciseArray.forEach { (exercise) in
            exercise.records.forEach { (item) in
                if StatisticExerciseModel.items.contains(where: { (type) -> Bool in type == item.type }) {
                    count += 1
                    records[item.type] = (records[item.type] ?? 0) + 1
                }
            }
        }
    }
    
    static let items: [BDSportType] = {
        if SupportUtils.targetType == .wbfit, BandConnect.protocolType == .series_z  {
            return [.walk, .run, .bike, .climbing, .football, .basketball, .badminton, .pingPong, .swiming]
        } else {
            return [.walk, .run, .bike, .climbing, .football, .basketball, .badminton, .pingPong]
        }
    } ()
    
    static let maxLen: CGFloat = {
        var len: CGFloat = 0
        for item in items {
            let val = item.text.widthForFont(font: nil)
            if  val > len { len = val }
        }
        len += 4
        return max(min(len, 150), 60)
    } ()
}
