//
//  DateBarCell.swift
//  CTFit
//
//  Created by Mac on 2020/6/4.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import SnapKit
import TableViewManager;

final class DateBarCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: DateBarItem!
    
    typealias ZJCelltemClass = DateBarItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        guard item != nil else { return }
        dateBar.intervalStyle = item.type
        dateBar.loadWithDate(item.date)
    }
    
    // MARK: - Initialize

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        backgroundColor = .clear
        setSubviews()
    }

    // MARK: - View customer

    private func setSubviews() {
        [dateBar].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        dateBar.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    @objc
    private func valueChanged(dateBar: DateBar) {
        if let hasSelectedDate = dateBar.selectedDate {
            item.date = hasSelectedDate
        } else if let hasSelectedWeek = dateBar.selectedWeekend {
            item.date = hasSelectedWeek.end
        } else if let hasSelectedMonth = dateBar.selectedMonth {
            item.date = hasSelectedMonth.end
        } else if let hasSelectedYear = dateBar.selectedYear {
            item.date = hasSelectedYear.end
        }
        guard let block = item.valueChanged else { return }
        block(dateBar)
    }
    
    private lazy var dateBar: DateBar = {
        let bar = DateBar()
        bar.addTarget(self, action: #selector(valueChanged(dateBar:)), for: .valueChanged)
        return bar
    }()
}


final class DateBarListCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: DateBarItem!
    
    typealias ZJCelltemClass = DateBarItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        guard item != nil else { return }
        dateBar.intervalStyle = item.type
        dateBar.loadWithDate(item.date)
    }
    
    // MARK: - Initialize

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        setSubviews()
    }

    // MARK: - View customer

    private func setSubviews() {
        [dateBar].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        dateBar.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    @objc
    private func valueChanged(dateBar: DateBar) {
        if let hasSelectedDate = dateBar.selectedDate {
            item.date = hasSelectedDate
        } else if let hasSelectedWeek = dateBar.selectedWeekend {
            item.date = hasSelectedWeek.start
        } else if let hasSelectedMonth = dateBar.selectedMonth {
            item.date = hasSelectedMonth.start
        } else if let hasSelectedYear = dateBar.selectedYear {
            item.date = hasSelectedYear.start
        }
        guard let block = item.valueChanged else { return }
        block(dateBar)
    }
    
    private lazy var dateBar: DateBar = {
        let bar = DateBar()
        bar.addTarget(self, action: #selector(valueChanged(dateBar:)), for: .valueChanged)
        return bar
    }()
}
