//
//  DateBarItem.swift
//  CTFit
//
//  Created by Mac on 2020/6/4.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

final class DateBarItem: BaseTableViewItem {
    
    typealias DateBarValueChanged = (DateBar) -> Void
    
    var valueChanged: DateBarValueChanged?
    
    var type: IntervalStyle = .day
    
    var date: Date = Date()
    
    private let calendar = CalendarUtils.calendar

    var dateInterval: DateInterval {
        switch type {
        case .day: return DateInterval(start: date, end: date)
        case .week: return calendar.weekInterval(containing: date)
        case .month: return calendar.monthInterval(containing: date)
        case .year: return calendar.yearInterval(containing: date)
        }
    }

    
    private override init() {
        super.init()
        selectionStyle = .none
        accessoryType = .none
        cellHeight = 55
    }
    
    convenience init(with type: IntervalStyle = .day, date: Date = Date()) {
        self.init()
        self.type = type
        self.date = date
    }
    
    func onValueChanged(block: @escaping DateBarValueChanged) {
        valueChanged = block
    }
}
