//
//  GoalAlarmDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/25.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation

enum GoalAlarmType {
    case step, calories, distance
    
    var text: String {
        switch self {
        case .step: return SRString.SportSet.goal_steps.locastr
        case .calories: return SRString.SportSet.goal_calories.locastr
        case .distance: return SRString.SportSet.goal_distance.locastr
        }
    }
    
    func vibrate(_ reachRing: BDReachRing) -> BDVibrate {
        switch self {
        case .step: return reachRing.step
        case .calories: return reachRing.calories
        case .distance: return reachRing.distance
        }
    }
        
    func setVibrate(_ reachRing: BDReachRing, _ vibrate: BDVibrate) {
        switch self {
        case .step: reachRing.step = vibrate.copy()
        case .calories: reachRing.calories = vibrate.copy()
        case .distance: reachRing.distance = vibrate.copy()
        }
    }
        
    var itemType: SettingPickerItemType {
        switch self {
        case .step: return .goalStep
        case .calories: return .goalCalories
        case .distance: return .goalDistance
        }
    }
}

final class GoalAlarmDatasource {
    init(with type: GoalAlarmType, settingsInfo: inout BandSettings) {
        self.type = type
        self.settingsInfo = settingsInfo
    }
    
    // MARK: - items lazy
    lazy var vibrateItem: VibrateItem? = {
        guard type == .step else { return nil }
        let item = VibrateItem(with: type.vibrate(settingsInfo.reachRing))
        item.setValueChanged { [weak self] (vibrate)in
            guard let strong = self else { return }
            strong.type.setVibrate(strong.settingsInfo.reachRing, vibrate)
        }
        return item
    } ()

    lazy var valueItem: SettingPickerItem = {
        return SettingPickerItem(with: type.itemType, settingsInfo: &settingsInfo)
    } ()
    
    
    // MARK: - private field
    fileprivate var type: GoalAlarmType = .step
    fileprivate var settingsInfo: BandSettings!
}
