//
//  GoalAlarmViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/25.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import TableViewManager

class GoalAlarmViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
        
    // MARK: - override
    
    deinit {
        onDidChanged()
    }
    
    override private init() {
        super.init()
    }
    
    convenience init(with type: GoalAlarmType, settingsInfo: inout BandSettings) {
        self.init()
        navigationItem.title = type.text
        datasource = GoalAlarmDatasource(with: type, settingsInfo: &settingsInfo)
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }

    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    // MARK: - tableViewManger
    
    private func setupTableView() {
        tableViewManger.reload();
    }
            
    private var datasource: GoalAlarmDatasource!
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(PickerCell.self, PickerItem.self)
        manager.register(VibrateCell.self, VibrateItem.self)
        manager.register(SettingPickerCell.self, SettingPickerItem.self)
        if let section = vibrateSection { manager.add(section: section) }
        manager.add(section: valueSection)

        return manager
    } ()
    
    private lazy var vibrateSection: ZJTableViewSection? = {
        guard let item = datasource.vibrateItem else { return nil}
        let section = ZJTableViewSection()
        section.headerHeight = Constraints.normal; section.footerHeight = 0.01;
        section.add(item: item)
        return section
    } ()
    
    private lazy var valueSection: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = Constraints.normal; section.footerHeight = 0.01;
        datasource.valueItem.addSubPickerItem(to: section)
        section.add(item: datasource.valueItem)
        return section
    } ()
}
