//
//  HeartAlarmDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/25.
//  Copyright © 2020 jpaxh. All rights reserved.
//


import Foundation

enum HeartAlarmType {
    case high, low
    
    var text: String {
        switch self {
        case .high: return SRString.SportSet.reminder_heart_high.locastr
        case .low: return SRString.SportSet.reminder_heart_low.locastr
        }
    }
    
    var describe: String {
        switch self {
        case .high: return SRString.SportSet.reminder_heart_high_describe.locastr
        case .low: return SRString.SportSet.reminder_heart_low_describe.locastr
        }
    }
    
    var itemType: SettingPickerItemType {
        switch self {
        case .high: return .heartHigh
        case .low: return .heartLow
        }
    }
    
    func heartValue(_ alarmExercise: BDAlarmExercise) -> UInt8 {
        switch self {
        case .high: return alarmExercise.heartRateHigh
        case .low: return alarmExercise.heartRateLow
        }
    }
    
    func enable(_ alarmExercise: BDAlarmExercise) -> Bool {
        switch self {
        case .high: return alarmExercise.highestEnable
        case .low: return alarmExercise.lowestEnable
        }
    }
    
    func setEnable(_ alarmExercise: BDAlarmExercise, _ enable: Bool) {
        switch self {
        case .high: alarmExercise.highestEnable = enable
        case .low: alarmExercise.lowestEnable = enable
        }
    }
}

final class HeartAlarmDatasource {
    
    func setOnFeatureValueChanged(_ closrue: @escaping SwitchItem.ValueChangedClosure) {
        self.onFeatureValueChanged = closrue
    }
    
    init(with type: HeartAlarmType, settingsInfo: inout BandSettings) {
        self.type = type
        self.settingsInfo = settingsInfo
    }
    
    
    // MARK: - items lazy
    lazy var featureItem: SwitchItem = {
        let item = SwitchItem(with: .feature_enable, isOn: type.enable(settingsInfo.heartRateAlarm))
        item.setOnValueChanged { [weak self] (enable) in
            guard let strong = self else { return }
            strong.type.setEnable(strong.settingsInfo.heartRateAlarm, enable)
            if let closure = strong.onFeatureValueChanged { closure(enable) }
        }
        return item
    }()
    
    lazy var vibrateItem: VibrateItem? = {
        if type == .low { return nil}
        let item = VibrateItem(with: settingsInfo.heartRateAlarm.vibrate)
        item.setValueChanged { [weak self] (vibrate)in
            guard let strong = self else { return }
            strong.settingsInfo.heartRateAlarm.vibrate = vibrate
        }
        return item
    } ()

    lazy var valueItem: SettingPickerItem = {
        return SettingPickerItem(with: type.itemType, settingsInfo: &settingsInfo)
    } ()
    
    // MARK: - private field
    private var onFeatureValueChanged: SwitchItem.ValueChangedClosure? = nil
    fileprivate var type: HeartAlarmType = .high
    fileprivate var settingsInfo: BandSettings!
}
