//
//  HeartAlarmViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/25.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import TableViewManager

class HeartAlarmViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
        
    // MARK: - override
    
    deinit {
        onDidChanged()
    }
    
    override private init() {
        super.init()
    }
    
    convenience init(with type: HeartAlarmType, settingsInfo: inout BandSettings) {
        self.init()
        self.type = type
        navigationItem.title = type.text
        datasource = HeartAlarmDatasource(with: type, settingsInfo: &settingsInfo)
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }

    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    // MARK: - tableViewManger
        
    private var type: HeartAlarmType = .high
    
    private var datasource: HeartAlarmDatasource!
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(SwitchCell.self, SwitchItem.self)
        manager.register(PickerCell.self, PickerItem.self)
        manager.register(VibrateCell.self, VibrateItem.self)
        manager.register(SettingPickerCell.self, SettingPickerItem.self)
        manager.add(section: featureSection)
        if datasource.featureItem.isOn {
            if let section = vibrateSection { manager.add(section: section) }
            manager.add(section: valueSection)
        }

        return manager
    } ()
    
    private lazy var featureSection: ZJTableViewSection = {
        let section = ZJTableViewSection()
        section.headerHeight = Constraints.normal; section.footerHeight = 0.01;
        section.add(item: datasource.featureItem)
        return section
    } ()
    
    private lazy var vibrateSection: ZJTableViewSection? = {
        guard let item = datasource.vibrateItem else { return nil}
        let section = ZJTableViewSection()
        section.headerHeight = Constraints.normal; section.footerHeight = 0.01;
        section.add(item: item)
        return section
    } ()
    
    private lazy var valueSection: ZJTableViewSection = {
        let section = BaseTableViewSection(customFooter: type.describe)
        section.headerHeight = Constraints.normal; section.footerHeight = Constraints.large;
        datasource.valueItem.addSubPickerItem(to: section)
        section.add(item: datasource.valueItem)
        return section
    } ()
    
    private func setupTableView() {
        tableViewManger.reload();
        datasource.setOnFeatureValueChanged { [weak self] (enable) in
            guard let strong = self else { return }
            strong.didChangedFeature(enable)
        }
    }
    
    private func didChangedFeature(_ enable: Bool) {
        onDidChanged()
        if enable {
            if let section = vibrateSection { tableViewManger.add(section: section) }
            tableViewManger.add(section: valueSection)
            var sections = [Int]()
            if let index = vibrateSection?.index { sections.append(index) }
            if let index = valueSection.index { sections.append(index) }
            customView.tableView.insertSections(sections, animationStyle: .fade)
        } else {
            var sections = [Int]()
            if let index = vibrateSection?.index { sections.append(index) }
            if let index = valueSection.index { sections.append(index) }
            if let section = vibrateSection { tableViewManger.remove(section: section) }
            tableViewManger.remove(section: valueSection)
            customView.tableView.deleteSections(sections, animationStyle: .fade)
        }
    }
}
