//
//  PickersDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/16.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation

enum PersonalPickerType {
    case height, weight, mmhg_reference
    case strideWalk, strideRun

    var text: String {
        switch self {
        case .height: return SRString.Personal.height.locastr
        case .weight: return SRString.Personal.weight.locastr
        case .mmhg_reference: return SRString.BP.mmhg_reference.locastr
        case .strideWalk: return SRString.SportSet.stride_walk.locastr
        case .strideRun: return SRString.SportSet.stride_run.locastr
        }
    }
}

final class PickersDatasource {
    
    lazy var items = [SettingPickerItem]()
    
    init(with type: PersonalPickerType, settingsInfo: inout BandSettings ) {
        self.type = type
        self.settingsInfo = settingsInfo
        loadItems()
    }
    
    private func loadItems() {
        switch type {
        case .height: items.append(SettingPickerItem(with: .height, settingsInfo: &settingsInfo))
        case .weight: items.append(SettingPickerItem(with: .weight, settingsInfo: &settingsInfo))
        case .mmhg_reference:
            items.append(SettingPickerItem(with: .sbpReference, settingsInfo: &settingsInfo))
            items.append(SettingPickerItem(with: .dbpReference, settingsInfo: &settingsInfo))
        case .strideWalk: items.append(SettingPickerItem(with: .strideWalk, settingsInfo: &settingsInfo))
        case .strideRun: items.append(SettingPickerItem(with: .strideRun, settingsInfo: &settingsInfo))
        }
    }
    
    // MARK: - Private field
    private var type: PersonalPickerType

    private var settingsInfo: BandSettings!
}
