//
//  PickersViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/16.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import TableViewManager

class PickersViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
        
    // MARK: - override
    
    deinit {
        onDidChanged()
    }
    
    override private init() {
        super.init()
    }
    
    convenience init(with type: PersonalPickerType, settingsInfo: inout BandSettings ) {
        self.init()
        navigationItem.title = type.text
        datasource = PickersDatasource(with: type, settingsInfo: &settingsInfo)
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }

    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    // MARK: - tableViewManger
    
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    private var datasource: PickersDatasource!
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(SettingPickerCell.self, SettingPickerItem.self)
        manager.register(PickerCell.self, PickerItem.self)
        sections.forEach { (e) in manager.add(section: e) }
        return manager
    } ()
    
    private lazy var sections: [ZJTableViewSection] = {
        return datasource.items.map { (e) -> ZJTableViewSection in createSection(e)  }
    } ()
    
    private func createSection(_ item: SettingPickerItem) -> ZJTableViewSection {
        let section = BaseTableViewSection()
        section.headerHeight = Constraints.normal; section.footerHeight = 0.01;
        section.add(item: item)
        item.addSubPickerItem(to: section)
        return section
    }
    
}
