//
//  SingleViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/16.
//  Copyright © 2020 jpaxh. All rights reserved.
//


import Foundation
import TableViewManager

class SingleViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    deinit {
        onDidChanged()
    }
    
    convenience init(with type: SingleType, settingsInfo: inout BandSettings) {
        self.init()
        datasource = SingleDatasource(with: type, settingsInfo: &settingsInfo)
        navigationItem.title = type.text
    }
    
    private override init() {
        super.init()
        hidesBottomBarWhenPushed = true
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }

    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    // MARK: - tableViewManger
    private var datasource: SingleDatasource!
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(SingleCell.self, SingleItem.self)
        manager.add(section: section);
        return manager
    } ()
    
    private lazy var section: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = Constraints.normal
        datasource.items.forEach { (e) in section.add(item: e)}
        return section
    } ()
}

