//
//  SingleCell.swift
//  CTFit
//
//  Created by Mac on 2020/9/16.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import TableViewManager

final class SingleCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: SingleItem!
    
    typealias ZJCelltemClass = SingleItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        self.textLabel?.text = item.text
        self.accessoryType = item.accessoryType
    }
    
    // MARK: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
    }
}

final class SingleDialogCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: SingleItem!
    
    typealias ZJCelltemClass = SingleItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        self.textLabel?.text = item.text
        self.accessoryType = item.accessoryType
    }
    
    // MARK: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        backgroundColor = Colors.darkMode(Colors.dark, Colors.white)

    }
}
