//
//  SingleItem.swift
//  CTFit
//
//  Created by Mac on 2020/9/16.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import TableViewManager
import RxSwift

final class SingleItem: BaseTableViewItem {
        
    var value: Any!

    var text: String? {
        if let gender = value as? BDGenderType { return gender.text }
        if let handType = value as? BDHandType { return handType.text }
        if let hourly = value as? BDHourlyType { return hourly.text }
        if let system = value as? BDSystemType { return system.text }
        if let tempType = value as? BDTempUnitsType { return tempType.text }
        if let dateType = value as? BDDateformatType { return dateType.text }
        if let brightType = value as? BDBrightScreenTimeType { return brightType.text }
        return nil
    }
    
    // MARK: - Initialize
    override private init() {
        super.init()
    }
    
    convenience init(with value: Any, settingsInfo: inout BandSettings) {
        self.init()
        self.value = value
        self.settingsInfo = settingsInfo
        onHandler()
    }
    
    // MARK: - Private field
    private var settingsInfo: BandSettings!
}

extension SingleItem {
    private func onHandler() {
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.didSelectedHandler()
        }
    }

    private func didSelectedHandler() {
        if let gender = value as? BDGenderType { settingsInfo.user.gender = gender }
        if let handType = value as? BDHandType { settingsInfo.user.handType = handType }
        if let hourly = value as? BDHourlyType { settingsInfo.format.hourly = hourly }
        if let system = value as? BDSystemType { settingsInfo.format.system = system }
        if let tempType = value as? BDTempUnitsType { settingsInfo.format.tempUnit = tempType }
        if let dateType = value as? BDDateformatType { settingsInfo.format.dateFormat = dateType }
        if let brightType = value as? BDBrightScreenTimeType { settingsInfo.format.brightScreenTime = brightType }
        SingleItem.subject.onNext(self)
    }
}

extension SingleItem {
    private static let subject = PublishSubject<SingleItem>()
    public static var observable: Observable<SingleItem> {
        return subject.asObservable()
    }
}


