//
//  DeviceSettingDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/17.
//  Copyright © 2020 jpaxh. All rights reserved.
//


import Foundation
import RxSwift
import TableViewManager

final class DeviceSettingDatasource {
    
    var items: [DeviceSettingItem] = [DeviceSettingItem]()
    
    deinit {
        settingsInfo.saveToBand()
    }
    
    init() {
        DeviceSettingItemType.collection.forEach { (type) in
            
            switch type {
            case .temp_unit: if !BandSettings.tempUnitEnable { return }
            case .dateformat, .brightscreen_time: if !BandSettings.dateformat_detect_brightScrren { return }
            case .drinkwater_reminder: if !BandSettings.waterRemindEnable { return }
            case .no_disturb: if !BandSettings.nodisturb { return }
            default: break
            }
            items.append(DeviceSettingItem(type, settingsInfo: &settingsInfo))
        }
    }
    
    // MARK: - private field
    private lazy var settingsInfo: BandSettings = {
        let info = BandSettings.extract()
        return info
    } ()
}
