//
//  PersonalDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/14.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation

final class PersonalDatasource {
    
    lazy var headerView = PersonalHeaderView(with: &settingsInfo)

    lazy var fieldItems = [FieldItem]()
    
    lazy var selectItems = [PersonalItem]()

        
    // MARK: - Initialize
    deinit {
        settingsInfo.saveToBand()
    }
    
    init() {
        let nameField = FieldItem(with: .name, content: settingsInfo.user.nickname)
        let ageField = FieldItem(with: .age, content: "\(settingsInfo.user.age)")
        fieldItems.append(nameField)
        fieldItems.append(ageField)
        nameField.setDidChangedClosure { [weak self] () in
            guard let strong = self else { return }
            let newName = nameField.content
            if strong.settingsInfo.user.nickname != newName {
                strong.settingsInfo.user.nickname = newName
                let info = BandSettings.extract()
                info.user.nickname = newName
                info.saveToCache()
            }
        }
        
        ageField.setDidChangedClosure { [weak self] () in
            self?.settingsInfo.user.age = UInt8(ageField.content ?? "0") ?? 20
        }
        
        PersonalItemType.collection.forEach { (type) in
            if type == .hand_type, !BandSettings.handEnable { return }
            if type == .mmhg_reference, !BandSettings.bpEnable { return }
            selectItems.append(PersonalItem(with: type, settingsInfo: &settingsInfo))
        }
    }
       
    
    // MARK: - private field
    
    private lazy var settingsInfo: BandSettings = BandSettings.extract()
}

