//
//  PersonalViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/14.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import TableViewManager

class PersonalViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    override init() {
        super.init()
        hidesBottomBarWhenPushed = true
        navigationItem.title = SRString.Settings.personal.locastr
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupTableView()
        addLongPressGesture()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }

    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    // MARK: - tableViewManger
    
    private lazy var datasource: PersonalDatasource = PersonalDatasource()
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
         manager.register(FieldCell.self, FieldItem.self)
        manager.register(PersonalCell.self, PersonalItem.self)
        manager.add(section: section);
        return manager
    } ()
    
    private lazy var section: ZJTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 170
        section.footerHeight = 0.01
         section.headerView = datasource.headerView
         datasource.fieldItems.forEach { (e) in section.add(item: e)}
        datasource.selectItems.forEach { (e) in section.add(item: e)}
        return section
    } ()        
}

extension PersonalViewController {

    // MARK: Private
    fileprivate func addLongPressGesture() {
        let gesture = UILongPressGestureRecognizer(target: self, action: #selector(longPressGestureAction(_:)))
        // 设定最小的长按时间 按不够这个时间不响应手势
        gesture.minimumPressDuration = 0.5;
        // 添加到整个View
        view.addGestureRecognizer(gesture)
    }

    @objc
    fileprivate func longPressGestureAction(_ gesture: UILongPressGestureRecognizer) {
        if gesture.state == .began {
             datasource.selectItems.first?.reloadCell()
        }
    }
}


