//
//  PersonalCell.swift
//  CTFit
//
//  Created by Mac on 2020/9/14.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import TableViewManager

final class PersonalCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: PersonalItem!
    
    typealias ZJCelltemClass = PersonalItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        self.textLabel?.text = item.text
        self.detailTextLabel?.text = item.detailText

    }
    
    // MARK: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .value1, reuseIdentifier: reuseIdentifier)
        accessoryView = arrowView
    }

}
