//
//  SettingsViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/10.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager
import Toast

class SettingsViewController: BaseViewController, CustomView {

    typealias ViewClass = BaseTableView
    
    override init() {
        super.init()
        navigationItem.title = SRString.Settings.settings.locastr
        modalPresentationStyle = .fullScreen
    }

    override func loadView() {
        super.loadView()
        view = ViewClass()
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        observeBandConnectState()
        setupTableView()
        addLongPressGesture()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        customView.refreshTableView()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
    }
    
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    // MARK: - TableViewManager
    
    fileprivate lazy var datasource: SettingsDatasource = SettingsDatasource();
        
    fileprivate lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(SettingsCell.self, SettingsItem.self)
        manager.add(section: section);
        return manager;
    } ()
    
    fileprivate lazy var section: BaseTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.footerHeight = 0.01
        datasource.items.forEach { (item) in section.add(item: item) }
        return section
    } ()
}


import FileBrowser
extension SettingsViewController {
    
    // MARK: Private
    fileprivate func addLongPressGesture() {
        let gesture = UILongPressGestureRecognizer(target: self, action: #selector(longPressGestureAction(_:)))
        // 设定最小的长按时间 按不够这个时间不响应手势
        gesture.minimumPressDuration = 1.5;
        // 添加到整个View
        view.addGestureRecognizer(gesture)
    }
    
    @objc
    fileprivate func longPressGestureAction(_ gesture: UILongPressGestureRecognizer) {
        if gesture.state == .began {
            FileBrowser.docmentBrower()
        }
    }
}
