//
//  SportSettingDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/24.
//  Copyright © 2020 jpaxh. All rights reserved.
//


import Foundation
import RxSwift
import TableViewManager


final class SportSettingDatasource {
    
    var items: [SportSettingItem] = [SportSettingItem]()
    
    deinit {
        settingsInfo.saveToBand()
    }
    
    init() {
        SportSettingItemType.collection.forEach { (type) in
            items.append(SportSettingItem(type, settingsInfo: &settingsInfo))
        }
    }
    
    // MARK: - private field
        
    private lazy var settingsInfo: BandSettings = {
        let info = BandSettings.extract()
        return info
    } ()
}
