//
//  SportSettingViewController.swift
//  CTFit
//
//  Created by Mac on 2020/9/24.
//  Copyright © 2020 jpaxh. All rights reserved.
//


import UIKit
import RxSwift
import TableViewManager
import Toast

class SportSettingViewController: BaseViewController, CustomView {

    typealias ViewClass = BaseTableView
    
    override init() {
        super.init()
        hidesBottomBarWhenPushed = true
        navigationItem.title = SRString.Settings.sport.locastr
    }

    override func loadView() {
        super.loadView()
        view = ViewClass()
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        observeBandConnectState()
        setupTableView()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        customView.refreshTableView()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
    }
    
    private func setupTableView() {
        tableViewManger.reload()
    }
    
    // MARK: - TableViewManager
    
    fileprivate lazy var datasource: SportSettingDatasource = SportSettingDatasource();
    
    fileprivate lazy var section: BaseTableViewSection = {
        let section = BaseTableViewSection()
        section.headerHeight = 0.01
        section.footerHeight = 0.01
        datasource.items.forEach { (item) in section.add(item: item) }
        return section
    } ()
    
    fileprivate lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(SportSettingCell.self, SportSettingItem.self)
        manager.add(section: section);
        return manager;
    } ()
}
