//
//  FieldCell.swift
//  CTFit
//
//  Created by Mac on 2020/7/16.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import TableViewManager

final class FieldCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: FieldItem!
    
    typealias ZJCelltemClass = FieldItem
    
    override func cellWillAppear() {
        self.textLabel?.text = item.text
        textField.text = item.content
        if let lenght = item.maxLenght { self.delegateWrapper.maxLenght = lenght }
        if textField.attributedPlaceholder == nil {
            let attributes: [NSAttributedString.Key: Any] = [.foregroundColor : Colors.Cell.value.withAlphaComponent(0.6),
                                                             .font : UIFont.customFont(ofSize: 14)]
            textField.attributedPlaceholder = NSAttributedString(string: item.type.text, attributes: attributes)
        }
        if textField.rightView == nil {
            let view = UIView(frame: CGRect(x: 0, y: 0, width: Constraints.normal, height: item.cellHeight))
            view.isUserInteractionEnabled = false
            textField.rightView = view
            textField.rightViewMode = .always
        }
    }
    
    // MARK: - Initialize

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        setConstraints()
    }
    
    // MARK: - View customer

    private func setConstraints() {
        [textField].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        textField.snp.makeConstraints { (make) in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(60)
            make.trailing.equalTo(self.snp.trailingMargin)
        }
        
        delegateWrapper.setInputFilterClosure { [unowned self] (text) -> Bool in
            return self.item.onInputFilter(text)
        }
        delegateWrapper.setDidChangedClosure { [unowned self] text in
            self.item.content = text
        }
    }
    
    lazy var textField: UITextField = {
        let field = UITextField()
        field.returnKeyType = .done
        field.textAlignment = .right
        field.font = .customFont(ofSize: 14)
        field.textColor = Colors.Cell.value
        field.delegate = delegateWrapper
        return field
    } ()
    
    lazy var delegateWrapper: TextFieldDelegateWrapper = {
        let wrapper = TextFieldDelegateWrapper()
        return wrapper
    } ()
}
