//
//  FieldItem.swift
//  CTFit
//
//  Created by Mac on 2020/7/17.
//  Copyright © 2020 shirajo. All rights reserved.
//


import Foundation
import TableViewManager

enum FieldItemType {
    case label, name, age
    var text: String {
        switch self {
        case .label: return SRString.Clock.label.locastr
        case .name: return SRString.Personal.nickname.locastr
        case .age: return SRString.Personal.age.locastr
        }
    }
}

final class FieldItem: BaseTableViewItem {
    
    var type: FieldItemType = .label
    
    var maxLenght: Int?

    var content: String? {
        didSet {
            guard content != oldValue else { return }
            onDidChanged()
        }
    }
    
    func setDidChangedClosure(_ closure:@escaping DidChangedClosure) {
        didChangedClosure = closure
    }
    
    func onInputFilter(_ text: String) -> Bool {
        if type == .age {
            let regex: String = "^[0-9]*$"
            let predicate: NSPredicate = NSPredicate(format: "SELF MATCHES %@",regex)
            let result: Bool = predicate.evaluate(with: text)
            guard result else { return false}
            guard text.count > 0 else { return true}
            guard let age = Int(text) else { return false}
            if age < 0 || age > 200 { return false }
        }
        return true
    }
    
    // MARK: - Cell source
    
    var text: String { type.text }
    
    // MARK: - Initialize
    
    private override init() {
        super.init()
        selectionStyle = .none
        accessoryType = .none
    }
    
    convenience init(with type: FieldItemType, content: String? = nil, maxLenght: Int? = nil) {
        self.init()
        self.type = type
        self.content = content
        self.maxLenght = maxLenght
    }
    
    // MARK: Private Field
    
    typealias DidChangedClosure = ()->Void
    
    private var didChangedClosure: DidChangedClosure?
    
    private func onDidChanged() {
        guard let closure = didChangedClosure else { return }
        closure()
    }
}
