//
//  PickerCell.swift
//  CTFit
//
//  Created by Mac on 2020/9/12.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import SnapKit
import TableViewManager

final class PickerCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: PickerItem!
    
    typealias ZJCelltemClass = PickerItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        onUpdate()
    }
    
    // MARK: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        initialize()
    }
    
    private func initialize() {
        [pickerView].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        pickerView.snp.makeConstraints({ (make) in
            make.top.bottom.equalToSuperview()
            make.leading.equalTo(self.snp.leadingMargin)
            make.trailing.equalTo(self.snp.trailingMargin)
        })
    }
    
    lazy var pickerView: BasePickerView = {
        let view = BasePickerView()
        view.setItemSelected { [weak self] (text, component) in
            guard let strong = self else { return }
            strong.item.onDidSelected(text, component)
        }
        return view
    } ()

    // MARK: - View customer
    private func onUpdate() {
        pickerView.resetComponents(item.components)
        pickerView.select(item.selectRows, false)
    }
}
