//
//  File.swift
//  CTFit
//
//  Created by Mac on 2020/9/12.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import TableViewManager

final class PickerItem: BaseExpandTreeCellItem {
    func setItemSelectedClosure(_ closure: @escaping BasePickerView.ItemSelectedEvent) {
        self.itemSelectedClosure = closure
    }

    // MARK: - Cell source
    var components = [[String]]()
    var selectRows = [String]()
    func onDidSelected(_ text: String, _ component: Int) {
        itemSelectedClosure?(text, component)
    }
    
    // MARK: - Initialize
    override init() {
        super.init()
        selectionStyle = .none
        accessoryType = .none
        cellHeight = 150
    }
    convenience init(components: [[String]], selectRows: [String]) {
        self.init()
        self.components = components
        self.selectRows = selectRows
    }
    
    
    // MARK: - private field
    private var itemSelectedClosure: BasePickerView.ItemSelectedEvent? = nil
    
}
