//
//  SettingsCell.swift
//  CTFit
//
//  Created by Mac on 2020/9/17.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import SnapKit
import TableViewManager

final class SettingsCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    var item: SettingsItem!
    typealias ZJCelltemClass = SettingsItem
    override func cellWillAppear() {
        imageView?.image = item.icon
        textLabel?.text = item.text
    }
    
    // MARK: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
    }
}
