//
//  SwitchCell.swift
//  CTFit
//
//  Created by Mac on 2020/6/1.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import SnapKit
import RxSwift
import TableViewManager;


final class SwitchCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    
    var item: SwitchItem!
    
    typealias ZJCelltemClass = SwitchItem
    
    override func cellWillAppear() {
        super.cellWillAppear()
        self.textLabel?.text = item.text
        self.switchControl.setOn(item.isOn, animated: true)
    }
    
    // MARK: - Initialize
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        setConstraints()
    }
    
    // MARK: - View customer
    
    private func setConstraints() {
        [switchControl].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        self.switchControl.snp.makeConstraints { (make) in
            make.centerY.equalToSuperview()
            make.trailing.equalTo(self.snp.trailingMargin)
        }
    }
    
    private let disposeBag = DisposeBag()

    lazy var switchControl: UISwitch = {
        let _switch = UISwitch()
        _switch.rx.isOn.asObservable()
        .subscribe(onNext: {[unowned self] (isOn) in
            self.item?.setIsOn(isOn)
        })
        .disposed(by: disposeBag)
        return _switch
    }()
}
