//
//  SwitchItem.swift
//  CTFit
//
//  Created by Mac on 2020/6/1.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

enum SwitchIdType {
    
    case feature_enable, background_sound, homeStyle

    var text: String {
        switch self {
        case .feature_enable: return SRString.Base.turn_on_off.locastr
        case .background_sound: return SRString.Application.sound_effect.locastr
        case .homeStyle: return SRString.Application.home_style_switch.locastr
        }
    }
}

final class SwitchItem: BaseTableViewItem {
    
    
    // MARK: - Cell source
        
    var isOn: Bool = false
    
    var text: String { type.text }
    
    func setIsOn(_ isOn: Bool) {
        guard self.isOn != isOn else { return }
        self.isOn = isOn
        if let closure = didValueChanged { closure(isOn) }
    }
    
    func setOnValueChanged(_ closure: @escaping ValueChangedClosure) {
        didValueChanged = closure
    }
    
    // MARK: - Initialize

    private override init() {
        super.init()
        selectionStyle = .none
        accessoryType = .none
    }
    
    convenience init(with type: SwitchIdType, isOn: Bool) {
        self.init()
        self.type = type
        self.isOn = isOn
        
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.setIsOn(!strong.isOn)
            strong.reload()

        }
    }

    // MARK: - private field
    typealias ValueChangedClosure = (Bool) -> Void
    private var didValueChanged: ValueChangedClosure?
    var type: SwitchIdType = .feature_enable

}
