//
//  SportHistoryViewController.swift
//  CTFit
//
//  Created by Mac on 2020/6/20.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager

class SportHistoryViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView

    override init() {
        super.init()
        hidesBottomBarWhenPushed = true
        navigationItem.title = SRString.Sport.sport_history.locastr
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        addSubviews()
        setupTableView()
        datasource.queryAllRecords()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    
    // MARK: - View customer    
    private func addSubviews() {
        [nodataLabel].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            self.view.addSubview(view)
        }
        
        nodataLabel.snp.makeConstraints { (make) in
            make.center.equalTo(customView.tableView.snp.center)
        }
    }
    
    private lazy var nodataLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.text)
        label.textColor = Colors.gray
        label.text = SRString.Sport.sport_history_nodata.locastr
        label.isHidden = false
        return label
    } ()
    
    // MARK: tableViewManger
    private func setupTableView() {
        datasource.didUpdateRecords = { [weak self] () in
            guard let strong = self else { return }
            strong.didUpdateRecords()
        }
        datasource.queryRecords(Date())
    }
    
    private lazy var datasource: SprotHistoryDatasource = SprotHistoryDatasource()
    
    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(SportHistoryCell.self, SportHistoryItem.self)
        manager.add(section: section)
        return manager
    } ()
    
    private lazy var section: ZJTableViewSection = {
        let _section = ZJTableViewSection()
        _section.headerHeight = 0.1 ;_section.footerHeight = Constraints.small
        return _section;
    }()
    
    
}

extension SportHistoryViewController {

    @objc private func valueChanged(dateBar: DateBar) {
        datasource.queryRecords(dateBar.selectedDate!)
    }

    private func didUpdateRecords() {
        section.removeAllItems()
        datasource.recordItems.forEach { [weak self] (e) in
            guard let strong = self else { return }
            strong.section.add(item: e)
        }
        tableViewManger.reload()
        nodataLabel.isHidden = datasource.recordItems.count > 0 ? true : false
    }
}

