//
//  SprotHistoryDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/6/20.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import RxSwift

final class SprotHistoryDatasource {
    
    var didUpdateRecords: (()->Void)?
    
    var recordItems: [SportHistoryItem] =  [SportHistoryItem]()
    
    init() {
        observers()
    }
    
    func queryRecords(_ date: Date) {
        let date = CalendarUtils.dayDate(for: date)
        recordItems.removeAll()
        let records = GpxRecord.querySportDay(date)
        records.forEach { (e) in
            let item = SportHistoryItem(with: e)
            recordItems.append(item)
            item.setDeletionHandler { [weak self] (item) in
                guard let strong = self else { return }
                strong.deleted(item as! SportHistoryItem)
            }
        }
        if let block = didUpdateRecords { block() }
    }
    
    func queryAllRecords() {
        recordItems.removeAll()
        let records = GpxRecord.queryAll()
        records.forEach { (e) in
            let item = SportHistoryItem(with: e)
            recordItems.append(item)
            item.setDeletionHandler { [weak self] (item) in
                guard let strong = self else { return }
                strong.deleted(item as! SportHistoryItem)
            }
        }
        if let block = didUpdateRecords { block() }
    }
    
    func deleted(_ item: SportHistoryItem) {
        GpxRecord.delete(startTime: item.record.startTime)
        recordItems.removeAll { (e) -> Bool in e == item }
        if let block = didUpdateRecords { block() }
    }
    
    
    private let disposeBag = DisposeBag()

    private func observers() {
        BandSettings.observable.subscribe(onNext: { [weak self] (options) in
            guard let strong = self else { return }
            guard options.contains(.system) else { return }
            strong.recordItems.forEach { (item) in item.reload() }
        }).disposed(by: disposeBag)
    }
}
