//
//  SportHistoryItem.swift
//  CTFit
//
//  Created by Mac on 2020/6/22.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager

final class SportHistoryItem: BaseTableViewItem {
    
    var record = SportRecorder()

    private override init() {
        super.init()
        self.cellHeight = 60
        selectionStyle = .default
        accessoryType = .none
        editingStyle = .delete
    }
    
    convenience init(with record: SportRecorder) {
        self.init()
        self.record = record
        setSelectionHandler { [weak self] (_) in
            guard let strong = self else { return }
            strong.toSportResultVC()
        }
    }
    
    convenience init(with record: GpxRecord) {
        self.init()
        self.record = SportRecorder(for: record)
        setSelectionHandler { [weak self] (_) in
            guard let strong = self else { return }
            strong.toSportResultVC()
        }
    }
    
    private func toSportResultVC() {
        let vc = SportResultViewController(record)
        Helper.currentVc?.navigationController?.pushViewController(vc, animated: true)
    }
}

