//
//  SportDetailViewController.swift
//  CTFit
//
//  Created by Mac on 2020/6/22.
//  Copyright © 2020 shirajo. All rights reserved.
//


import UIKit
import RxSwift
import TableViewManager

class SportDetailViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    override init() {
        super.init()
        navigationItem.title = SRString.Sport.detail.locastr
    }
    
    convenience init(_ sportRecord: SportRecorder) {
        self.init()
        datasource = SprotDetailDatasource(recorder: sportRecord)
    }
        
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = self.shareBarItem()

    }

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = Colors.black
        setupTableView()
    }
    
    // MARK: - tableViewManger

    private func setupTableView() {
        customView.tableView.backgroundColor = Colors.black
        tableViewManger.reload()
    }

    private var datasource: SprotDetailDatasource!

    private lazy var tableViewManger: ZJTableViewManager = {
        let manager = ZJTableViewManager(tableView: customView.tableView)
        manager.register(SportDetailPaceCell.self, SportDetailPaceItem.self)
        manager.register(SportDetailMoreCell.self, SportDetailMoreItem.self)
        manager.register(SportDetailChartCell.self, SportDetailChartItem.self)
        manager.add(section: paceSection)
        manager.add(section: moreSection)
        manager.add(section: chartSection)

        return manager
    } ()
     
    
    private lazy var paceSection: ZJTableViewSection = {
        let _section = ZJTableViewSection()
        _section.headerHeight = 0.1
        _section.add(item: datasource.paceItem)
        return _section
    }()
    
    private lazy var moreSection: ZJTableViewSection = {
        let _section = ZJTableViewSection()
        _section.headerHeight = Constraints.small
        _section.add(item: datasource.moreItem)
        return _section
    }()
    
    private lazy var chartSection: ZJTableViewSection = {
        let _section = ZJTableViewSection()
        _section.headerHeight = Constraints.small
        _section.add(item: datasource.chartItem)
        return _section
    }()
}

