//
//  SprotDetailDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/6/22.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager
import RxSwift

final class SprotDetailDatasource {
    
    var didUpdateRecords: (()->Void)?
    
    let recorder: SportRecorder
    
    lazy var paceItem: ZJTableViewItem =  SportDetailPaceItem(with: recorder)
    
    lazy var moreItem: ZJTableViewItem =  SportDetailMoreItem(with: recorder)
    
    lazy var chartItem: ZJTableViewItem =  SportDetailChartItem(with: recorder)


    init(recorder: SportRecorder) {
        self.recorder = recorder
        observers()
    }
    
    private let disposeBag = DisposeBag()

    private func observers() {
        BandSettings.observable.subscribe(onNext: { [weak self] (options) in
            guard let strong = self else { return }
            guard options.contains(.system) else { return }
            strong.paceItem.reload()
            strong.moreItem.reload()
            strong.chartItem.reload()
        }).disposed(by: disposeBag)
    }
}
