//
//  SportTrackViewController.swift
//  CTFit
//
//  Created by Mac on 2020/6/23.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class SportTrackViewController: BaseViewController, CustomView {

    typealias ViewClass = SportTrackView
    
    var recorder: SportRecorder!
    
    override init() {
        super.init()
        self.navigationItem.title = SRString.Sport.track.locastr
    }
    
    convenience init(_ sportRecord: SportRecorder) {
        self.init()
        recorder = sportRecord
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass(recorder)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.customView.onViewDidLoad()
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        LocationHelper.showNoLocationPermissionAlert()
        self.customView.onViewDidAppear()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        self.customView.onViewDidDisappear()

    }

    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = self.shareBarItem()
    }
}

