//
//  SportResultViewController.swift
//  CTFit
//
//  Created by Mac on 2020/6/22.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class SportResultViewController: BaseViewController {
    
    var sportRecord: SportRecorder!
    
    override init() {
        super.init()
        hidesBottomBarWhenPushed = true
    }
    
    convenience init(_ sportRecord: SportRecorder) {
        self.init()
        self.sportRecord = sportRecord
        navigationItem.title = (BDSportType.parse(UInt8(sportRecord.sportType)) ?? .normal).text
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
        navigationItem.rightBarButtonItem = self.shareBarItem()
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = Colors.black
        addSubviews()
        setupConstraints()
        setupSliderSwitch()
    }
    
    private func addSubviews() {
        [headerView, customView].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            self.view.addSubview(view)
        }
    }
    
    private func setupConstraints() {
        headerView.snp.makeConstraints { (make) in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        
        customView.snp.makeConstraints { (make) in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(headerView.snp.bottom)
        }
    }
    
    
    private func setupSliderSwitch() {
        self.customView.viewControllers = [SportDetailViewController(sportRecord),
                                           SportTrackViewController(sportRecord)]
    }
    
    
    lazy var customView: SliderSwitch = SliderSwitch(superController: self)
    
    lazy var headerView: UIView = {
        let view = UIView()
        view.backgroundColor = Colors.black
        customView.sliderSegmented.kFontSize = 18
        customView.sliderSegmented.kMaxScale = 1.0
        customView.sliderSegmented.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(customView.sliderSegmented)
        customView.sliderSegmented.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
        return view
    } ()
    
}
