//
//  SportHeaderView.swift
//  CTFit
//
//  Created by Mac on 2020/10/19.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class SportHeaderView: UIView {
    // MARK: - Initialize
    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    init() {
        super.init(frame: .zero)
        addSubviews()
        setupConstraints()
    }
    
    private func addSubviews() {
        [backgroundImageView, sportTypeLabel].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
    }

    private func setupConstraints() {
        self.heightAnchor.constraint(equalToConstant: 30).isActive = true;

        backgroundImageView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: -30-UIDevice.naviLayoutGuide, left: 0, bottom: 0, right: 0))
        }
        sportTypeLabel.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 8, right: 0))
        }
    }

    // MARK: - Filed
    private lazy var backgroundImageView: UIImageView = {
        let view = UIImageView(image: ImageRepo.Sport.bg_weather)
        view.backgroundColor = Colors.black
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    } ()
    
    lazy var sportTypeLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.title)
        label.textAlignment = .center
        label.textColor = Colors.white
        label.text = ""
        return label
    } ()
}
