//
//  SportView.swift
//  CTFit
//
//  Created by Mac on 2020/6/11.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
class SportView: UIView {
    func onViewDidLoad() { }
    func onViewDidAppear() { sportPresenter.requestAuthorization() }
    func onViewDidDisappear() { }

    // MARK: - Initialize

    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    init() {
        super.init(frame: .zero)
        addSubviews()
    }
    
    var exercising: Bool { bottomView.actionState == .selected }
    
    func startExercise(_ type: BDSportType, _ source: SportSource = .app) {
        bottomView.actionState = .selected
        sportPresenter.startExercise(type, source)
    }
    
    func finishExercise(_ source: SportSource = .app) {
        bottomView.actionState = .normal
        sportPresenter.finishExercise(source)
    }
    
    func onSportDidChanged(_ closure: @escaping SportPresenter.SportChangedClosure) {
        sportPresenter.sportChangedClosure = closure
    }
    
    // MARK: - View customer

    private lazy var sportPresenter: SportPresenter = SportPresenter()
    private lazy var mapView: MapView = sportPresenter.mapView
    private lazy var bottomView: SportBottomView = sportPresenter.bottomView
    private lazy var headerView: SportHeaderView = sportPresenter.headerView
    
    private func addSubviews() {
        [headerView, mapView, bottomView].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
   
        headerView.snp.makeConstraints { (make) in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview()
        }
        
        mapView.snp.makeConstraints { (make) in
            make.left.right.equalToSuperview()
            make.top.equalTo(headerView.snp.bottom)

        }
        
        bottomView.snp.makeConstraints { (make) in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(mapView.snp.bottom)
        }
    }
}

