//
//  ConnectedDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/9/5.
//  Copyright © 2020 jpaxh. All rights reserved.
//


import Foundation
import TableViewManager
import RxSwift

typealias HasUpdateClosure = () ->Void

final class ConnectedDatasource {
    
    var updateFeaturesClosure: HasUpdateClosure?
        
    lazy var deviceItem: ConnectedItem = {
        let item = ConnectedItem(.device)
        item.selectionStyle = .none
        return item
    } ()
    
    var featureItems: [ConnectedItem] = []
    
    
    init() {
        updateFeature()
        observe()
    }
    
    
    // MARK: - private
        
    private let disposeBag = DisposeBag()
    
    private func observe() {
        BandData.updatedOutput.observeOn(MainScheduler.instance).subscribe(onNext: { [weak self] type in
            guard let strong = self, case .firmwareInfo = type else { return }
            strong.updateFeature()
            strong.updateFeaturesClosure?()
        }).disposed(by: disposeBag)
    }
    
    private func updateFeature()  {
        switch BandConnect.protocolType {
        case .series_z:
            let feature = BandData.firmwareFeature
            var items = [ConnectedItem]()
            if feature.rest_find { items.append(ConnectedItem(.findBand)) }
            items.append(ConnectedItem(.delete))
            if SupportUtils.upgradeFeature { items.append(ConnectedItem(.upgrade)) }
            if feature.rest_find { items.append(ConnectedItem(.reset)) }
            if feature.camera    { items.append(ConnectedItem(.tackePicture)) }
            featureItems = items
        case .series_s:
            var items = [ConnectedItem]()
            items.append(ConnectedItem(.findBand))
            items.append(ConnectedItem(.delete))
            if BandConnect.peripheralName.hasPrefix("SW294")  { items.append(ConnectedItem(.reset)) }
            items.append(ConnectedItem(.tackePicture))
            featureItems = items
        }
    }
}
