import UIKit
import SnapKit
import TableViewManager

final class ConnectedCell: BaseTableViewCell, ZJCellProtocol {

    ///: - ZJCellProtocol
    var item: ConnectedItem!
    typealias ZJCelltemClass = ConnectedItem
    override func cellWillAppear() {
        textLabel?.text = item.text
        detailTextLabel?.text = item.detail
        selectionStyle = (item.type == .device ? .none : .default)
    }
    
    ///: - Initialize
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .value1, reuseIdentifier: reuseIdentifier)
    }
}
