//
//  ProtocolDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/7/23.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import RxSwift
import RxBluetoothKit
import BandKit

final class ProtocolDatasource {
    
    // MARK: -  field
        
    var connectionStateOutput: Observable<(SRConnectState)> {
        return SRKitService.connectionStateOutput
    }

    let synclist: [ProtocolItem] = [
        ProtocolItem(with: SRCommand.readPairWay()),
        ProtocolItem(with: SRCommand.readTransferSpeed()),
        ProtocolItem(with: SRCommand.readTime()),
        ProtocolItem(with: SRCommand.readAlarmClock()),
        ProtocolItem(with: SRCommand.readUserInfo()),
        ProtocolItem(with: SRCommand.readFirmwareInfo()),
        ProtocolItem(with: SRCommand.readFlashDates()),
        ProtocolItem(with: SRCommand.readRecordDetail(.step, .t0)),
        ProtocolItem(with: SRCommand.readDrinkInfo()),
        ProtocolItem(with: SRCommand.readDetectRecords()),
    ]
    
    let customlist: [ProtocolItem] = [
        ProtocolItem(with: SRCommand.pairiOS()),
        ProtocolItem(with: SRCommand.transferSpeed(.high)),
        ProtocolItem(with: SRCommand.transferSpeed(.low)),
        ProtocolItem(with: SRCommand.firmwareControl(type: .unbind)),
        ProtocolItem(with: SRCommand.firmwareControl(type: .upgrade)),
        ProtocolItem(with: SRCommand.firmwareControl(type: .poweroff)),

        ProtocolItem(with: SRCommand.restFactory()),
        ProtocolItem(with: SRCommand.findBandEvent()),
        ProtocolItem(with: SRCommand.cameraEvent(1)),
        ProtocolItem(with: SRCommand.cameraEvent(0)),
        ProtocolItem(with: SRCommand.gpsEvent(0)),
        ProtocolItem(with: SRCommand.gpsEvent(1)),
        ProtocolItem(with: SRCommand.exerciseStart(.walk)),
        ProtocolItem(with: SRCommand.detect(.bpm)),
        ProtocolItem(with: SRCommand.detect(.bp)),
        ProtocolItem(with: SRCommand.syncTime(SRDeviceTime())),
        ProtocolItem(with: SRCommand.setDrinkInfo(SRDrinkInfo())),
        ProtocolItem(with: SRCommand.setAlarmClock(SRAlarmClock())),
        ProtocolItem(with: SRCommand.setUserInfo(SRUserInfo())),
    ]

    // MARK: - Method
    func disconnect() {
        SRKitService.disconnect()
    }
    
}
