//
//  BindedViewController.swift
//  ctband
//
//  Created by Mac on 2020/4/21.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import RxSwift
import TableViewManager
import BandKit

class ProtocolViewController: BaseViewController, CustomView {
    
    typealias ViewClass = BaseTableView
    
    override init() {
        super.init()
        navigationItem.title = SRKitService.bindPeripheral?.name
    }

    override func loadView() {
        super.loadView()
        view = ViewClass(style: .plain)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        addDisconnectBarButtonItem()
        setupTableView()
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        customView.refreshTableView()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
    }
    
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        self.view.hideAllToasts()
    }
    
    /// - BarButtonItem
    
    private func addDisconnectBarButtonItem() {
        navigationItem.rightBarButtonItem = UIBarButtonItem(title: "Disconnect",
                                                            style: .plain,
                                                            target: self,
                                                            action: #selector(disconnectAction))
    }
    
    private func removeDisconnectBarButtonItem() {
        navigationItem.rightBarButtonItem = nil
    }
    
    @objc private func disconnectAction() {
        datasource.disconnect()
    }
   
    // MARK: - tableViewManger

    private lazy var datasource: ProtocolDatasource = ProtocolDatasource()
    private lazy var tableViewManger: ZJTableViewManager = {
        let manger = ZJTableViewManager(tableView: customView.tableView)
        manger.register(ProtocolCell.self, ProtocolItem.self)
        return manger
    } ()
    
    private lazy var readSection: BaseTableViewSection =  {
        let section = BaseTableViewSection(customHeader: "读取指令")
        return section
    } ()
    
    private lazy var writeSection: BaseTableViewSection =  {
        let section = BaseTableViewSection(customHeader: "写入指令")
        return section
    } ()
    
    fileprivate func setupTableView() {
        bindDatas();
        tableViewManger.add(section: readSection)
        tableViewManger.add(section: writeSection)
        datasource.synclist.forEach { (e) in
            e.isAutoHeight = true
            readSection.add(item: (e))
        }
        datasource.customlist.forEach { (e) in
            e.isAutoHeight = true
            writeSection.add(item: (e))
        }
    }
    
    
    fileprivate func bindDatas() {
        datasource.connectionStateOutput.observeOn(MainScheduler.instance).subscribe(onNext: { [unowned self] (state) in
            guard case .disconnected(let msg) = state else { return }
            var alert: (title: String, message: String) = ("", "")
            alert.title = "Disconnect"
            alert.message = msg
            self.removeDisconnectBarButtonItem()
            self.showAlert(alert.title, message: alert.message)
        }).disposed(by: disposeBag)
        
    }
    
    
    fileprivate func showAlert(_ title: String, message: String) {
        let alertController = UIAlertController(title: title, message: message, preferredStyle: .alert)
        let action = UIAlertAction(title: SRString.Base.ok.locastr, style: .default) { _ in
            self.dismiss(animated: true)
            self.navigationController?.popToRootViewController(animated: true)
        }
        alertController.addAction(action)
        present(alertController, animated: true)
    }
    
}
