//
//  ProtoclItem.swift
//  ctband
//
//  Created by Mac on 2020/4/27.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import TableViewManager;
import BandKit

final class ProtocolItem: BaseTableViewItem {
        
    // MARK: - Cell source
    var text: String { cmd.nameText }
    var detail: String { cmd.descripteText }
    
    // MARK: - Initialize
    override init() {
        super.init()
        accessoryType = .none
    }
    
    convenience init(with cmd: SRCommand) {
        self.init()
        self.cmd = cmd
        onHandler()
    }
    
    // MARK: - Field
    private var cmd: SRCommand = SRCommand()
    private func send() {
        cmd.style(.enforce).writeToDevice({ (value, error) in
            if let hasError = error {
                ToastUtils.showToastCCV(error: "\(hasError).")
            } else if let hasValue = value {
                ToastUtils.showToastCCV(data: "\(hasValue)")
            } else {
                ToastUtils.showToastCCV(normal: "Successful.")
            }
        })
    }
}

// MARK: - Handler actions

extension ProtocolItem {
    fileprivate func onHandler() {
        setSelectionHandler { [weak self] (item) in
            guard let strong = self else { return }
            strong.send()
        }
    }
}
